<?php
	/**
	 * Exam API client for Loorex.com.<br>
	 *
	 * @author   	loorex.com <support@loorex.com>
	 * @category 	API
	 * @version		1.3
	 * @since		24.10.2025
	 * @package		LoorexApi
	 * @link		http://loorex.com/docs/api/exam.html
	 */

	define("_LOOREX_QT_SINGLECHOICE",		1);
	define("_LOOREX_QT_MULTISELECT",		2);
	define("_LOOREX_QT_DRAGDROP",			3);
	define("_LOOREX_QT_POINTSHOOT",			4);
	define("_LOOREX_QT_HOTAREA",			5);
	define("_LOOREX_QT_REORDER",			6);
	define("_LOOREX_QT_TEXT_INPUT",			7);
	
	define('_LOOREX_EVAL_METHOD_SIMPLE_PERC',		1);
	define('_LOOREX_EVAL_METHOD_SIMPLE_POINTS',		2);
	define("_LOOREX_EVAL_METHOD_GRADES_PERC",		3);
	define("_LOOREX_EVAL_METHOD_GRADES_POINTS",		4);
	
	define('_LOOREX_DRAG_DROP_BLOCK_TARGET',		1);
	define('_LOOREX_DRAG_DROP_BLOCK_DRAGGABLE',		2);

	class LoorexApiExam extends LoorexApiBase {

		function __construct($accessToken) {
			parent::__construct($accessToken);
		}

		public function examList($params = []) {
			return $this->sendMessage('examList', $params);
		}

		public function examGet($examId) {
			return $this->sendMessage('examGet', ['id'=>$examId]);
		}

		public function examCreate($params) {
			$ret = $this->sendMessage('examCreate', $params);
			return ((isset($ret['id']) && $ret['id']) ? $ret['id'] : false);
		}

		public function examUpdate($params) {
			$ret = $this->sendMessage('examUpdate', $params);
			return ((isset($ret['completed']) && $ret['completed']) ? true : false);
		}

		public function examUpdateStatus($examId, $ready, $ignoreWarnings = false) {
			$ret = $this->sendMessage('examUpdateStatus', ['id'=>$examId,'ready'=>(($ready) ? true : false),'ignore_warnings'=>$ignoreWarnings]);
			return ((isset($ret['completed']) && $ret['completed']) ? true : false);
		}

		public function examDelete($examId) {
			$ret = $this->sendMessage('examDelete', ['id'=>$examId]);
			return ((isset($ret['completed']) && $ret['completed']) ? true : false);
		}

		public function questionList($examId) {
			return $this->sendMessage('questionList', ['test_id'=>$examId]);
		}

		public function questionGet($examId, $questionId) {
			return $this->sendMessage('questionGet', ['id'=>$questionId,'test_id'=>$examId]);
		}

		public function questionCreate($params) {
			$ret = $this->sendMessage('questionCreate', $params);
			$ret = ((isset($ret['completed']) && $ret['completed'] && isset($ret['question']['id']) && $ret['question']['id']) ? $ret['question']['id'] : false);
			return $ret;
		}

		public function questionUpdate($params) {
			$ret = $this->sendMessage('questionUpdate', $params);
			$ret = ((isset($ret['completed']) && $ret['completed'] && isset($ret['question']['id']) && $ret['question']['id']) ? true : false);
			return $ret;
		}

		public function questionDelete($examId, $questionId) {
			$ret = $this->sendMessage('questionDelete', ['id'=>$questionId,'test_id'=>$examId]);
			return ((isset($ret['completed']) && $ret['completed']) ? true : false);
		}
		
		public function gradeList($examId) {
			return $this->sendMessage('gradeList', ['test_id'=>$examId]);
		}

		public function gradeGet($examId, $gradeId) {
			return $this->sendMessage('gradeGet', ['id'=>$gradeId,'test_id'=>$examId]);
		}

		public function gradeCreate($params) {
			$ret = $this->sendMessage('gradeCreate', $params);
			$ret = ((isset($ret['completed']) && $ret['completed'] && isset($ret['grade']['id']) && $ret['grade']['id']) ? $ret['grade']['id'] : false);
			return $ret;
		}

		public function gradeUpdate($params) {
			$ret = $this->sendMessage('gradeUpdate', $params);
			$ret = ((isset($ret['completed']) && $ret['completed'] && isset($ret['grade']['id']) && $ret['grade']['id']) ? true : false);
			return $ret;
		}

		public function gradeDelete($examId, $gradeId) {
			$ret = $this->sendMessage('gradeDelete', ['id'=>$gradeId,'test_id'=>$examId]);
			return ((isset($ret['completed']) && $ret['completed']) ? true : false);
		}
		
		public function caseStudyList($examId) {
			return $this->sendMessage('caseStudyList', ['test_id'=>$examId]);
		}

		public function caseStudyGet($examId, $caseStudyId) {
			return $this->sendMessage('caseStudyGet', ['id'=>$caseStudyId,'test_id'=>$examId]);
		}

		public function caseStudyCreate($params) {
			$ret = $this->sendMessage('caseStudyCreate', $params);
			$ret = ((isset($ret['completed']) && $ret['completed'] && isset($ret['case_study']['id']) && $ret['case_study']['id']) ? $ret['case_study']['id'] : false);
			return $ret;
		}

		public function caseStudyUpdate($params) {
			$ret = $this->sendMessage('caseStudyUpdate', $params);
			$ret = ((isset($ret['completed']) && $ret['completed'] && $ret['case_study']['id']) ? true : false);
			return $ret;
		}

		public function caseStudyDelete($examId, $caseStudyId) {
			$ret = $this->sendMessage('caseStudyDelete', ['id'=>$caseStudyId,'test_id'=>$examId]);
			return ((isset($ret['completed']) && $ret['completed']) ? true : false);
		}

		protected function getApiName() {
			return 'exam';
		}
	}
?>